# Description

Include here a brief description of what this PR is doing. It can be the motivation for the PR, the context, and list the dependencies necessary for this change. Always remember to include the reference to the task you are working on (use #code).
Fixes # (issue)

## What has changed?

Delete options that are not relevant or create new ones if necessary

- [ ] Bug fix (fixes a bug but is a non-breaking change)
- [ ] New feature (adds a new feature and is a non-breaking change)
- [ ] Breaking change (fix or feature that breaks an existing feature)
- [ ] This change alters the contract

# How should this be tested?

Describe the tests to verify the changes. Describe the logic of the feature and any relevant changes required for testing.
For example:

1. Place an order with payment method X
2. Validate that fields Y, Z, A exist in the order
3. When the order is delivered, it should increment an analytic

- [ ] Test A
- [ ] Test B

# Checklist:

- [ ] Does my code follow the project's guidelines (architecture/defined standards/clean code/SOLID)?
- [ ] Did I perform a self-review of this PR?
- [ ] Did I comment on the code, especially in complex parts?
- [ ] Does this PR generate any warnings?
- [ ] Did I create automated tests?
- [ ] Did the unit tests pass?