# Hulp Aulas

Hulp Aulas is a digital platform that connects students with private tutors quickly and efficiently, inspired by the operating model of apps like Uber. The tool allows students to access the app, select their subject of interest, and view, in real time, available tutors to teach at the desired time. The goal is to offer a practical, fast, and personalized experience for those who need tutoring or learning in a specific subject.

---

## Instaling and Executing

To start using the project, follow the steps below.

### Prerequisites

Make sure you have the following software installed on your machine:

* **Node.js**: 18ˆ.
* **npm**: Node package menanger.

### Step by step

1. Clone the repository on your machine with ssh key:
    ```bash
    git clone git@github.com:coordenador-hulpaulas/hulp-aulas-api.git
    ```

2. Navigate to the project directory:
    ```bash
    cd hulp-aulas-api
    ```

3. Intall the dependencies:
    ```bash
    npm install
    ```

4. Copy `.env.example` file to `.env`:
    ```bash
    cp .env.example .env
    ```

5. Fill in the environment variables with your information. For example:
    ```env
    # Server configuration
    PORT=3000
    NODE_ENV=
    API_VERSION=your-version

    # Database configuration
    DB_PROTOCOL=mongodb
    DB_USERNAME=seu-user-name
    DB_PASSWORD=your-password
    DB_HOST=your-host
    DP_PORT=27017
    DB_DATABASE=development

    # JWT configuration
    JWT_SECRET=your-secret-key
    JWT_EXPIRES_IN=1h

    # Bcrypt configuration
    CRYPT_SALT_ROUNDS=5

    # Mailtrap configuration
    MAILTRAP_TOKEN=your-api-token
    MAILTRAP_SENDER_NAME=Hulp Aulas
    MAILTRAP_SENDER_EMAIL=dev@hulpaulas.com.br

    # SWAGGER API Info
    CONFIGURE_OPENAPI=false
    API_TITLE=your-api-title
    API_DESCRIPTION=api-description

    # SWAGGER Contact Info
    API_CONTACT_NAME=API example
    API_CONTACT_URL=https://your.domain:port
    API_CONTACT_EMAIL=mail@example.com

    # SWAGGER License info
    API_LICENSE_NAME=your-licence
    API_LICENSE_URL=example.licence.yourdomain.com

    # SWAGGER Server Info
    API_SERVER_URL=https://your.domain:port
    API_SERVER_DESCRIPTION=Description for this URL
    ```

6. Start the development server:
    ```bash
    npm run dev
    ```
    The server is running in `http://your.domain:{your-port}/` .

---

## API Route documentation via Swagger UI

After starting the server, you can access the interactive API documentation using Swagger UI:

```bash
http://{YOUR.DOMAIN}:{PORT}/{BASE_PATH}/docs
```

Replace the variables with the value set in your `.env` file.

Swagger UI allows you to view, test, and understand all available API endpoints.

---