"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const path_1 = __importDefault(require("path"));
const server_1 = require("../main/server");
const container_1 = require("../main/factories/container");
const OPEN_API_SPEC_FILE_LOCATION = path_1.default.resolve(__dirname, '../contracts/service.yaml');
exports.app = new server_1.Server({
    basePath: `/api/${process.env.API_VERSION || 'v1'}`,
    port: Number(process.env.PORT) || 3000,
    routers: container_1.Container.initialize(),
    timeoutMilliseconds: 30000,
});
