"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const userSchema = new mongoose_1.default.Schema({
    name: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
    },
});
const UserModel = mongoose_1.default.models.User || mongoose_1.default.model('User', userSchema);
afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
    yield UserModel.deleteMany({});
}));
describe('When we try to create & save a user', () => {
    it('should return the saved user successfully', () => __awaiter(void 0, void 0, void 0, function* () {
        const userData = { name: 'Lucas', email: 'lucas@whitebeard.com', password: 'pass123' };
        const validUser = new UserModel(userData);
        yield validUser.save();
        const savedUser = yield UserModel.findOne({ email: userData.email });
        expect(savedUser).toBeDefined();
        expect(savedUser.name).toBe(userData.name);
        expect(savedUser.email).toBe(userData.email);
    }));
});
