"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const user_model_1 = require("../../infrastructure/database/models/user.model");
let paramsCreate;
beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
    paramsCreate = {
        id: new mongoose_1.default.Types.ObjectId().toHexString(),
        email: 'whitebeard@email.com',
        name: 'Whitebeard',
        password: 'pass123',
        roles: ['student'],
        created_at: new Date(),
    };
}));
describe('When we try to create a valid user', () => {
    it('should return success when we try to create a valid user', () => __awaiter(void 0, void 0, void 0, function* () {
        const user = new user_model_1.MUser({
            _id: paramsCreate.id,
            name: paramsCreate.name,
            email: paramsCreate.email,
            password: paramsCreate.password,
            roles: paramsCreate.roles,
            created_at: paramsCreate.created_at,
        });
        yield user.save();
        const userInDb = yield user_model_1.MUser.findOne({ _id: paramsCreate.id }).lean();
        expect(userInDb).toBeDefined();
        expect(userInDb._id).toBe(paramsCreate.id);
        expect(userInDb.email).toBe(paramsCreate.email);
        expect(userInDb.name).toBe(paramsCreate.name);
        expect(userInDb.roles).toEqual(paramsCreate.roles);
    }));
});
