"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const server_1 = require("./main/server");
const container_1 = require("./main/factories/container");
/**
 * Create the application with Server instance
 */
exports.app = new server_1.Server({
    basePath: `/api/${process.env.API_VERSION}`,
    port: Number(process.env.PORT) || 3000,
    routers: container_1.Container.inicialize(),
    timeoutMilliseconds: 30000
});
/**
 * Start the server
 */
exports.app.start();
