"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseService = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
class DatabaseService {
    constructor() {
        this.protocol = process.env.DB_PROTOCOL;
        this.host = process.env.DB_HOST;
        this.port = process.env.DB_PORT || '27017';
        this.username = process.env.DB_USERNAME;
        this.password = process.env.DB_PASSWORD;
        this.database = process.env.DB_DATABASE;
        // Ensure complete connection string
        if (!this.protocol || !this.host || !this.database || !this.username || !this.password) {
            throw new AppError('Incomplete connection string', 500);
        }
        if (this.protocol == 'mongodb+srv') {
            this.databaseURI = this._buildAtlasURI();
        }
        else {
            this.databaseURI = this._buildLocalURI();
        }
    }
    /**
     * Connects to database
     */
    connect() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield mongoose_1.default.connect(this.databaseURI);
            }
            catch (error) {
                throw new AppError(`Failed to connect to MongoDB: ${error.message}`, 500);
            }
        });
    }
    /**
     * Close database connection
     */
    disconnect() {
        return __awaiter(this, void 0, void 0, function* () {
            yield mongoose_1.default.disconnect();
        });
    }
    /**
     * Create connection string for localhost
     */
    _buildLocalURI() {
        return `${this.protocol}://${this.username}:${this.password}@${this.host}:${this.port}/${this.database}`;
    }
    /**
     * Create connection string for atlas
     */
    _buildAtlasURI() {
        return `${this.protocol}://${this.username}:${this.password}@${this.host}/${this.database}?retryWrites=true&w=majority`;
    }
}
exports.DatabaseService = DatabaseService;
