"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MClass = void 0;
const base_model_1 = require("./shared/base.model");
const mongoose_1 = __importDefault(require("mongoose"));
exports.MClass = mongoose_1.default.model('Class', new mongoose_1.default.Schema(Object.assign(Object.assign({}, base_model_1.baseSchemaDefinition), { name: {
        type: String,
        required: true,
    }, main_student_id: {
        type: String,
        required: true,
    }, teacher_id: {
        type: String,
        required: true,
    }, topic_id: {
        type: String,
        required: true,
    }, additional_students: {
        type: [String],
        required: false,
        default: [],
    }, link: {
        type: String,
        required: false,
        default: "",
    }, streaming_id: {
        type: String,
        required: false,
        default: "",
    }, type: {
        type: String,
        required: true,
        enum: ['individual', 'group'],
    }, start_time: {
        type: Date,
        required: true,
    }, end_time: {
        type: Date,
        required: true,
    }, status: {
        type: String,
        required: true,
        enum: ['scheduled', 'canceled', 'completed']
    }, payment_status: {
        type: String,
        required: true,
        enum: ['pending', 'paid', 'refunded'],
    } }), base_model_1.baseSchemaOptions));
