"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseSchemaOptions = exports.baseSchemaDefinition = void 0;
const uuid_1 = require("uuid");
/**
 * The base Schema with default proprieties from all Mongoose Schemas
 */
exports.baseSchemaDefinition = {
    _id: {
        type: String,
        default: () => (0, uuid_1.v7)(),
    },
};
/**
 * Base options Schema with timestamp proprieties from all Mongoose Schemas
 */
exports.baseSchemaOptions = {
    timestamps: {
        createdAt: 'created_at',
        updatedAt: 'updated_at',
    },
};
