"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MStudent = void 0;
const base_model_1 = require("./shared/base.model");
const mongoose_1 = __importDefault(require("mongoose"));
const AvaliableTimes = new mongoose_1.default.Schema({
    day_of_week: {
        type: Number,
        required: true,
    },
    start_time: {
        type: Number,
        required: true,
    },
    end_time: {
        type: Number,
        required: true,
    },
}, {
    _id: false,
});
exports.MStudent = mongoose_1.default.model('Student', new mongoose_1.default.Schema(Object.assign(Object.assign({}, base_model_1.baseSchemaDefinition), { full_name: {
        type: String,
        required: true,
    }, birth_date: {
        type: Date,
        required: true,
    }, gender: {
        type: String,
        required: false,
    }, cpf: {
        value: {
            type: String,
            required: true,
        },
        upload_id: {
            type: mongoose_1.default.Types.ObjectId,
            reference: "Upload",
            required: false,
        },
    }, rg: {
        value: {
            type: String,
            required: false,
        },
        upload_id: {
            type: mongoose_1.default.Types.ObjectId,
            reference: "Upload",
            required: false,
        },
    }, email: {
        type: String,
        required: true,
        unique: true,
        match: [
            /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
            'Please provide a valid email address'
        ],
    }, password: {
        type: String,
        required: true,
    }, password_reset: {
        token: {
            type: String,
            required: false,
            default: null,
        },
        expires_at: {
            type: Date,
            required: false,
            default: null,
        }
    }, telephone: {
        type: String,
        required: true,
    }, academic: {
        current_grade: {
            type: String,
            required: true
        },
        school: {
            type: String,
            required: false
        },
        subjects: {
            type: [String],
            required: true
        },
        difficulty_level: {
            type: String,
            required: true
        },
        main_goal: {
            type: String,
            required: true
        },
    }, ranking: {
        type: Number,
        required: true
    }, total_classes: {
        type: Number,
        required: true,
    }, class_preferences: {
        frequency: {
            type: String,
            required: true
        },
        available_times: [AvaliableTimes],
        preferred_teacher: {
            type: String,
            required: false
        },
    }, guardian: {
        full_name: {
            type: String,
            required: false
        },
        birth_date: {
            type: Date,
            required: false,
        },
        telephone: {
            type: String,
            required: false
        },
        email: {
            type: String,
            required: false
        },
        relationship: {
            type: String,
            required: false
        },
        cpf: {
            value: {
                type: String,
                required: false,
            },
            upload_id: {
                type: mongoose_1.default.Types.ObjectId,
                reference: "Upload",
                required: false,
            },
        },
        rg: {
            value: {
                type: String,
                required: false,
            },
            upload_id: {
                type: mongoose_1.default.Types.ObjectId,
                reference: "Upload",
                required: false,
            },
        },
    }, financial: {
        credit_card_registered: {
            type: Boolean,
            required: false
        },
        card_info: {
            cardholder_name: {
                type: String,
                required: false
            },
            card_number: {
                type: String,
                required: false
            },
            expiration: {
                type: String,
                required: false
            },
            cvv: {
                type: String,
                required: false
            },
        },
    } }), base_model_1.baseSchemaOptions));
