"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MTeacher = void 0;
const base_model_1 = require("./shared/base.model");
const mongoose_1 = __importDefault(require("mongoose"));
const addressSchema_1 = require("./shared/addressSchema");
const cpfSchema_1 = require("./shared/cpfSchema");
const passwordResetSchema_1 = require("./shared/passwordResetSchema");
const availableTimesSchema_1 = require("./shared/availableTimesSchema");
const cpfCnpjSchema_1 = require("./shared/cpfCnpjSchema");
// Sub document for education data
const educationSchema = new mongoose_1.default.Schema({
    level: {
        type: String,
        required: true,
    },
    field: {
        type: String,
        required: true,
    },
    teaching_experience: {
        type: String,
        required: true,
    },
    disciplines: {
        type: [String],
        required: true,
    },
    education_levels: {
        type: [String],
        required: true,
    },
}, {
    _id: false
});
// Sub document for avaliability data
const availabilitySchema = new mongoose_1.default.Schema({
    in_person_location: {
        type: [String],
        required: false,
    },
    available_times: [availableTimesSchema_1.availableTimesSchema],
    accepts_emergency_classes: {
        type: Boolean,
        required: false,
    },
}, {
    _id: false
});
const paymentSchema = new mongoose_1.default.Schema({
    hourly_rate: {
        type: Number,
        required: true,
    },
    payment_info: {
        type: {
            type: String,
            required: true,
        },
        key: {
            type: String,
            required: true,
        },
    }
}, {
    _id: false
});
const preferencesSchema = new mongoose_1.default.Schema({
    student_type_preference: {
        type: String,
        required: false,
    },
    general_observations: {
        type: String,
        required: false,
    },
}, {
    _id: false
});
exports.MTeacher = mongoose_1.default.model('Teacher', new mongoose_1.default.Schema(Object.assign(Object.assign({}, base_model_1.baseSchemaDefinition), { full_name: {
        type: String,
        required: true,
    }, cpfCnpj: {
        type: cpfCnpjSchema_1.cpfCnpjSchema,
        required: true,
    }, rg: {
        type: cpfSchema_1.docsSchema,
        required: false,
    }, email: {
        type: String,
        required: true,
        unique: true,
        match: [
            /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
            'Please provide a valid email address'
        ],
    }, password: {
        type: String,
        required: true,
    }, password_reset: {
        type: passwordResetSchema_1.passwordResetSchema,
        required: false,
        default: null,
    }, telephone: {
        type: String,
        required: true
    }, birth_date: {
        type: Date,
        required: true
    }, image_profile: {
        type: String,
        required: false,
    }, address: {
        type: addressSchema_1.addressSchema,
        required: false,
        default: null,
    }, education: {
        type: educationSchema,
        required: false,
        default: null
    }, availability: {
        type: availabilitySchema,
        required: false,
        default: null
    }, payment: {
        type: paymentSchema,
        required: false,
        default: null
    }, preferences: {
        type: preferencesSchema,
        required: false,
        default: null
    } }), base_model_1.baseSchemaOptions));
