"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MUser = void 0;
const base_model_1 = require("./shared/base.model");
const mongoose_1 = __importDefault(require("mongoose"));
const passwordResetSchema_1 = require("./shared/passwordResetSchema");
exports.MUser = mongoose_1.default.model('User', new mongoose_1.default.Schema(Object.assign(Object.assign({}, base_model_1.baseSchemaDefinition), { name: {
        type: String,
        required: true,
    }, email: {
        type: String,
        required: true,
        unique: true, // Assuming emails are unique
        match: [
            /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
            'Please provide a valid email address',
        ],
    }, password: {
        type: String,
        required: true,
    }, is_active: {
        type: Boolean,
        required: true,
        default: true, // Default to active user
    }, email_verified_at: {
        type: Date,
        required: false,
        default: null, // Default to null if not verified
    }, password_reset: {
        type: passwordResetSchema_1.passwordResetSchema,
        required: false,
        default: null,
    }, roles: {
        type: [String],
        required: true,
        default: [],
    } }), base_model_1.baseSchemaOptions));
