"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryRepository = void 0;
const category_model_1 = require("../database/models/category.model");
class CategoryRepository {
    /**
     * Creates a new category in the database
     * @param category - Category data to be created
     * @returns The created category
     */
    createCategory(category) {
        return __awaiter(this, void 0, void 0, function* () {
            const newCategory = yield category_model_1.MCategory.create(category);
            return this.adaptor(newCategory);
        });
    }
    /**
     * Finds a category by ID
     * @param id - Category ID
     * @returns The found category or null
     */
    findCategoryById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const category = yield category_model_1.MCategory.findOne({ _id: id });
            return this.adaptor(category);
        });
    }
    /**
     * Finds a category by name
     * @param name - Category name
     * @returns The found category or null
     */
    findCategoryByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const category = yield category_model_1.MCategory.findOne({ name });
            return this.adaptor(category);
        });
    }
    /**
     * Lists categorys according to filter
     * @param filter - Search filter
     * @returns Array of found categorys
     */
    listCategories(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const categorys = yield category_model_1.MCategory.find(filter);
            return categorys.map(category => this.adaptor(category));
        });
    }
    /**
     * Updates a category by ID
     * @param id - Category ID
     * @param data - Data for update
     * @returns The updated category or null
     */
    updateCategoryById(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const category = yield category_model_1.MCategory.findOneAndUpdate({ _id: id }, { $set: data }, { new: true });
            return this.adaptor(category);
        });
    }
    /**
     * Deletes a category by ID
     * @param id - Category ID
     * @returns The deleted category or null
     */
    deleteCategoryById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const category = yield category_model_1.MCategory.findByIdAndDelete(id);
            return this.adaptor(category);
        });
    }
    /**
     * Adapts the mongoose document to the ICategory model
     * @param category - Mongoose document
     * @returns The adapted category or null
     */
    adaptor(category) {
        if (!category)
            return null;
        const _a = category.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.CategoryRepository = CategoryRepository;
