"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassRepository = void 0;
const class_model_1 = require("../database/models/class.model");
class ClassRepository {
    /**
     * Creates a new class in the database
     * @param class - Class data to be created
     * @returns The created class
     */
    createClass(classData) {
        return __awaiter(this, void 0, void 0, function* () {
            const newClass = yield class_model_1.MClass.create(classData);
            return this.adaptor(newClass);
        });
    }
    /**
     * Finds a class by ID
     * @param id - Class ID
     * @returns The found class or null
     */
    findClassById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const classData = yield class_model_1.MClass.findOne({ _id: id });
            return this.adaptor(classData);
        });
    }
    /**
     * Lists classs according to filter
     * @param filter - Search filter
     * @returns Array of found classs
     */
    listClasses(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const query = this.configureQueryObject(filter);
            const classes = yield class_model_1.MClass.find(query);
            return classes.map(classData => this.adaptor(classData));
        });
    }
    /**
     * Updates a class by ID
     * @param id - Class ID
     * @param data - Data for update
     * @returns The updated class or null
     */
    updateClassById(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const classData = yield class_model_1.MClass.findOneAndUpdate({ _id: id }, { $set: data }, { new: true });
            return this.adaptor(classData);
        });
    }
    /**
     * Deletes a class by ID
     * @param id - Class ID
     * @returns The deleted class or null
     */
    deleteClassById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const classData = yield class_model_1.MClass.findByIdAndDelete(id);
            return this.adaptor(classData);
        });
    }
    /**
     * Adapts the mongoose document to the IClass model
     * @param class - Mongoose document
     * @returns The adapted class or null
     */
    adaptor(classData) {
        if (!classData)
            return null;
        const _a = classData.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
    configureQueryObject(query) {
        const filter = {};
        if (query.topic_id) {
            filter.topic_id = query.topic_id;
        }
        if (query.teacher_id) {
            filter.teacher_id = query.teacher_id;
        }
        if (query.status) {
            filter.status = query.status;
        }
        if (query.type) {
            filter.type = query.type;
        }
        if (query.payment_status) {
            filter.payment_status = query.payment_status;
        }
        if (query.student_id) {
            filter.main_student_id = query.student_id;
        }
        if (query.start_time) {
            filter.start_time = { $lt: query.end_time };
        }
        if (query.end_time) {
            filter.end_time = { $gt: query.start_time };
        }
        return filter;
    }
}
exports.ClassRepository = ClassRepository;
