"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineRepository = void 0;
const discipline_model_1 = require("../database/models/discipline.model");
class DisciplineRepository {
    /**
     * Creates a new discipline in the database
     * @param discipline - Discipline data to be created
     * @returns The created discipline
     */
    createDiscipline(discipline) {
        return __awaiter(this, void 0, void 0, function* () {
            const newDiscipline = yield discipline_model_1.MDiscipline.create(discipline);
            return this.adaptor(newDiscipline);
        });
    }
    /**
     * Finds a discipline by ID
     * @param id - Discipline ID
     * @returns The found discipline or null
     */
    findDisciplineById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const discipline = yield discipline_model_1.MDiscipline.findOne({ _id: id });
            return this.adaptor(discipline);
        });
    }
    /**
     * Finds a discipline by name
     * @param name - Discipline name
     * @returns The found discipline or null
     */
    findDisciplineByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const discipline = yield discipline_model_1.MDiscipline.findOne({ name });
            return this.adaptor(discipline);
        });
    }
    /**
     * Lists disciplines according to filter
     * @param filter - Search filter
     * @returns Array of found disciplines
     */
    listDisciplines(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const disciplines = yield discipline_model_1.MDiscipline.find(filter);
            return disciplines.map(discipline => this.adaptor(discipline));
        });
    }
    /**
     * Updates a discipline by ID
     * @param id - Discipline ID
     * @param data - Data for update
     * @returns The updated discipline or null
     */
    updateDisciplineById(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const discipline = yield discipline_model_1.MDiscipline.findOneAndUpdate({ _id: id }, { $set: data }, { new: true });
            return this.adaptor(discipline);
        });
    }
    /**
     * Deletes a discipline by ID
     * @param id - Discipline ID
     * @returns The deleted discipline or null
     */
    deleteDisciplineById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const discipline = yield discipline_model_1.MDiscipline.findByIdAndDelete(id);
            return this.adaptor(discipline);
        });
    }
    /**
     * Adapts the mongoose document to the IDiscipline model
     * @param discipline - Mongoose document
     * @returns The adapted discipline or null
     */
    adaptor(discipline) {
        if (!discipline)
            return null;
        const _a = discipline.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.DisciplineRepository = DisciplineRepository;
