"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesRepository = void 0;
const roles_model_1 = require("../database/models/roles.model");
class RolesRepository {
    /**
     * Create a new role in the database
     * @param rolesData - The role data to create
     * @returns The created role document
     */
    createRole(rolesData) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRole = yield roles_model_1.MRole.create(rolesData);
            return this.adaptor(newRole);
        });
    }
    /**
     * Find a role by ID
     * @param id - The role's ID
     * @returns The role document or null if not found
     */
    findRoleById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const role = yield roles_model_1.MRole.findOne({ _id: id });
            return this.adaptor(role);
        });
    }
    /**
     * Find a role by name
     * @param name - The role's name
     * @returns The role document or null if not found
     */
    findRoleByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const role = yield roles_model_1.MRole.findOne({ name });
            return this.adaptor(role);
        });
    }
    /**
     * List all roles
     * @param filter - Filter to apply
     * @returns - An array of roles documents
     */
    listRole(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const roles = yield roles_model_1.MRole.find(filter);
            return roles.map(role => this.adaptor(role));
        });
    }
    /**
     * Update a role by ID
     * @param id - The role's ID
     * @param updateData - The data to update
     * @returns The updated role document or null if not found
     */
    updateRoleById(id, updateData) {
        return __awaiter(this, void 0, void 0, function* () {
            const role = yield roles_model_1.MRole.findOneAndUpdate({ _id: id }, // filter
            { $set: updateData }, // partial update
            { new: true });
            return this.adaptor(role);
        });
    }
    /**
     * Delete a role by ID
     * @param id - The role's ID
     * @returns The deleted role document or null if not found
     */
    deleteRoleById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const role = yield roles_model_1.MRole.findOneAndDelete({ _id: id });
            return this.adaptor(role);
        });
    }
    /**
     * Adapts a MRole(mongoose) document to a IRole document (JSON)
     * @param role - The Mrole document
     * @returns The adapted Irole document or null if not found
     */
    adaptor(role) {
        if (!role)
            return null;
        const _a = role.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.RolesRepository = RolesRepository;
