"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentRepository = void 0;
const student_model_1 = require("../database/models/student.model");
class StudentRepository {
    /**
     * Creates a new student in the database
     * @param student - Student data to be created
     * @returns The created student
     */
    createStudent(student) {
        return __awaiter(this, void 0, void 0, function* () {
            const newStudent = yield student_model_1.MStudent.create(student);
            return this.adaptor(newStudent);
        });
    }
    /**
     * Finds a student by ID
     * @param id - Student ID
     * @returns The found student or null
     */
    getStudentById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const student = yield student_model_1.MStudent.findOne({ _id: id });
            return this.adaptor(student);
        });
    }
    /**
     * Finds a student by email
     * @param email - Student email
     * @returns The found student or null
     */
    getStudentByEmail(email) {
        return __awaiter(this, void 0, void 0, function* () {
            const student = yield student_model_1.MStudent.findOne({ email });
            return this.adaptor(student);
        });
    }
    /**
     * Lists students according to filter
     * @param filter - Search filter
     * @returns Array of found students
     */
    listStudents(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const students = yield student_model_1.MStudent.find(filter);
            return students.map(student => this.adaptor(student));
        });
    }
    /**
     * Updates a student by ID
     * @param id - Student ID
     * @param data - Data for update
     * @returns The updated student or null
     */
    updateStudent(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const student = yield student_model_1.MStudent.findOneAndUpdate({ _id: id }, { $set: data }, { new: true });
            return this.adaptor(student);
        });
    }
    /**
     * Deletes a student by ID
     * @param id - Student ID
     * @returns The deleted student or null
     */
    deleteStudent(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const student = yield student_model_1.MStudent.findByIdAndDelete(id);
            return this.adaptor(student);
        });
    }
    /**
     * Adapts the mongoose document to the IStudent model
     * @param student - Mongoose document
     * @returns The adapted student or null
     */
    adaptor(student) {
        if (!student)
            return null;
        const _a = student.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.StudentRepository = StudentRepository;
