"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherRepository = void 0;
const teacher_model_1 = require("../database/models/teacher.model");
class TeacherRepository {
    /**
     * Get the model name in MongoDB
     * @returns - The model name
     */
    getClassName() {
        return teacher_model_1.MTeacher.collection.name;
    }
    /**
     * Creates a new teacher in the database
     * @param teacher - teacher data to be created
     * @returns The created teacher
     */
    createTeacher(teacher) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTeacher = yield teacher_model_1.MTeacher.create(teacher);
            return this.adaptor(newTeacher);
        });
    }
    /**
     * Finds a teacher by ID
     * @param id - teacher ID
     * @returns The found teacher or null
     */
    getTeacherById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const teacher = yield teacher_model_1.MTeacher.findOne({ _id: id });
            return this.adaptor(teacher);
        });
    }
    /**
     * Finds a teacher by email
     * @param email - teacher email
     * @returns The found teacher or null
     */
    getTeacherByEmail(email) {
        return __awaiter(this, void 0, void 0, function* () {
            const teacher = yield teacher_model_1.MTeacher.findOne({ email });
            return this.adaptor(teacher);
        });
    }
    /**
     * Lists teachers according to filter
     * @param filter - Search filter
     * @returns Array of found teachers
     */
    listTeachers(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const teachers = yield teacher_model_1.MTeacher.find(filter);
            return teachers.map(teacher => this.adaptor(teacher));
        });
    }
    findTeachersWithAggregate(pipeline) {
        return __awaiter(this, void 0, void 0, function* () {
            const teachers = yield teacher_model_1.MTeacher.aggregate(pipeline);
            return teachers.map(teacher => this.adaptor(teacher));
        });
    }
    /**
     * Updates a teacher by ID
     * @param id - teacher ID
     * @param data - Data for update
     * @returns The updated teacher or null
     */
    updateTeacherById(id, teacher) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTeacher = yield teacher_model_1.MTeacher.findOneAndUpdate({ _id: id }, { $set: teacher }, { new: true });
            return this.adaptor(newTeacher);
        });
    }
    /**
     * Deletes a teacher by ID
     * @param id - teacher ID
     * @returns The deleted teacher or null
     */
    deleteTeacherById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTeacher = yield teacher_model_1.MTeacher.findByIdAndDelete(id);
            return this.adaptor(newTeacher);
        });
    }
    /**
     * Adapts the mongoose document to the Iteacher model
     * @param teacher - Mongoose document
     * @returns The adapted teacher or null
     */
    adaptor(teacher) {
        if (!teacher)
            return null;
        if (typeof teacher.toObject === 'function') {
            const _a = teacher.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
            return Object.assign({ id: _id.toString() }, response);
        }
        else {
            const { _id, __v } = teacher, response = __rest(teacher, ["_id", "__v"]);
            return Object.assign({ id: _id.toString() }, response);
        }
    }
}
exports.TeacherRepository = TeacherRepository;
