"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRepository = void 0;
const topic_model_1 = require("../database/models/topic.model");
class TopicRepository {
    /**
     * Creates a new topic in the database
     * @param topic - Topic data to be created
     * @returns The created topic
     */
    createTopic(topic) {
        return __awaiter(this, void 0, void 0, function* () {
            const newTopic = yield topic_model_1.MTopic.create(topic);
            return this.adaptor(newTopic);
        });
    }
    /**
     * Finds a topic by ID
     * @param id - Topic ID
     * @returns The found topic or null
     */
    findTopicById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const topic = yield topic_model_1.MTopic.findOne({ _id: id });
            return this.adaptor(topic);
        });
    }
    /**
     * Finds a topic by name
     * @param name - Topic name
     * @returns The found topic or null
     */
    findTopicByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const topic = yield topic_model_1.MTopic.findOne({ name });
            return this.adaptor(topic);
        });
    }
    /**
     * Lists topics according to filter
     * @param filter - Search filter
     * @returns Array of found topics
     */
    listTopics(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const topics = yield topic_model_1.MTopic.find(filter);
            return topics.map(topic => this.adaptor(topic));
        });
    }
    /**
     * Updates a topic by ID
     * @param id - Topic ID
     * @param data - Data for update
     * @returns The updated topic or null
     */
    updateTopicById(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const topic = yield topic_model_1.MTopic.findOneAndUpdate({ _id: id }, { $set: data }, { new: true });
            return this.adaptor(topic);
        });
    }
    /**
     * Deletes a topic by ID
     * @param id - Topic ID
     * @returns The deleted topic or null
     */
    deleteTopicById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const topic = yield topic_model_1.MTopic.findByIdAndDelete(id);
            return this.adaptor(topic);
        });
    }
    /**
     * Adapts the mongoose document to the ITopic model
     * @param topic - Mongoose document
     * @returns The adapted topic or null
     */
    adaptor(topic) {
        if (!topic)
            return null;
        const _a = topic.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.TopicRepository = TopicRepository;
