"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRepository = void 0;
const user_model_1 = require("../database/models/user.model");
class UserRepository {
    /**
     * Create a new user in the database
     * @param userData - The user data to create
     * @returns The created user document
     */
    createUser(userData) {
        return __awaiter(this, void 0, void 0, function* () {
            const newUser = yield user_model_1.MUser.create(userData);
            return this.adaptor(newUser);
        });
    }
    /**
     * Find a user by ID
     * @param id - The user's ID
     * @returns The user document or null if not found
     */
    findUserById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const user = yield user_model_1.MUser.findOne({ _id: id });
            return this.adaptor(user);
        });
    }
    /**
     * Find a user by email
     * @param email - The user's email
     * @returns The user document or null if not found
     */
    findUserByEmail(email) {
        return __awaiter(this, void 0, void 0, function* () {
            const user = yield user_model_1.MUser.findOne({ email });
            return this.adaptor(user);
        });
    }
    /**
     * List all users
     * @param filter - Optional filters for the query
     * @returns An array of user documents
     */
    listUsers(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const users = yield user_model_1.MUser.find(filter);
            return users.map(user => this.adaptor(user));
        });
    }
    /**
     * Update a user by ID
     * @param id - The user's ID
     * @param updateData - The data to update
     * @returns The updated user document or null if not found
     */
    updateUserById(id, updateData) {
        return __awaiter(this, void 0, void 0, function* () {
            const user = yield user_model_1.MUser.findOneAndUpdate({ _id: id }, // filter
            { $set: updateData }, // partial update
            { new: true });
            return this.adaptor(user);
        });
    }
    /**
     * Delete a user by ID
     * @param id - The user's ID
     * @returns The deleted user document or null if not found
     */
    deleteUserById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const user = yield user_model_1.MUser.findOneAndDelete({ _id: id });
            return this.adaptor(user);
        });
    }
    /**
     * Adapts a MUser(mongoose) document to a IUser document (JSON)
     * @param user - The MUser document
     * @returns The adapted IUser document or null if not found
     */
    adaptor(user) {
        if (!user)
            return null;
        const _a = user.toObject(), { _id, __v } = _a, response = __rest(_a, ["_id", "__v"]);
        return Object.assign({ id: _id.toString() }, response);
    }
}
exports.UserRepository = UserRepository;
