"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthMiddlewareFactory = void 0;
const auth_middleware_1 = require("../../../shared/middlewares/auth.middleware");
/**
 * Generic factory for creating authentication middlewares
 * @template T - Type of entity that extends IAuthenticatableEntity
 * @template R - Type of registration parameters that extends IRegisterParams
 */
class AuthMiddlewareFactory {
    /**
     * Creates a generic authentication middleware
     * @template T - Type of entity that extends IAuthenticatableEntity
     * @template R - Type of registration parameters that extends IRegisterParams
     * @param authService - Generic authentication service
     * @returns Authentication middleware
     */
    static create(authService) {
        return (0, auth_middleware_1.CreateAuthMiddleware)(authService);
    }
}
exports.AuthMiddlewareFactory = AuthMiddlewareFactory;
