"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryControllerFactory = void 0;
const category_controller_1 = require("../../../modules/Category/category.controller");
const category_schema_1 = require("../../schemas/category.schema");
/**
 * Factory class to create CategoryController instances.
 */
class CategoryControllerFactory {
    /**
     * Create and return a new CategoryController instance
     * @returns CategoryController instance
     */
    static create(service) {
        return new category_controller_1.CategoryController(service, category_schema_1.categorySchemas);
    }
}
exports.CategoryControllerFactory = CategoryControllerFactory;
