"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryRouterFactory = void 0;
const category_router_1 = require("../../routes/category.router");
/**
 * Factory class to create CategoryRouter instances.
 */
class CategoryRouterFactory {
    /**
     * Create and return a new CategoryRouter instance
     * @returns CategoryRouter instance
     */
    static create(controller, authMiddleware, permissionsMiddleware) {
        return new category_router_1.CategoryRouter(controller, authMiddleware, permissionsMiddleware);
    }
}
exports.CategoryRouterFactory = CategoryRouterFactory;
