"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryServiceFactory = void 0;
const category_service_1 = require("../../../modules/Category/category.service");
/**
 * Factory class to create CategoryService instances.
 */
class CategoryServiceFactory {
    /**
     * Create and return a new CategoryService instance
     * @returns CategoryService instance
     */
    static create(repository) {
        return new category_service_1.CategoryService({ repository });
    }
}
exports.CategoryServiceFactory = CategoryServiceFactory;
