"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassControllerFactory = void 0;
const class_controller_1 = require("../../../modules/Class/class.controller");
const class_schema_1 = require("../../schemas/class.schema");
/**
 * Factory class to create ClassController instances.
 */
class ClassControllerFactory {
    /**
     * Create and return a new ClassController instance
     * @returns ClassController instance
     */
    static create(service) {
        return new class_controller_1.ClassController(service, class_schema_1.classSchemas);
    }
}
exports.ClassControllerFactory = ClassControllerFactory;
