"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassServiceFactory = void 0;
const class_service_1 = require("../../../modules/Class/class.service");
/**
 * Factory class to create ClassService instances.
 */
class ClassServiceFactory {
    /**
     * Create and return a new ClassService instance
     * @returns ClassService instance
     */
    static create(repository) {
        return new class_service_1.ClassService({ repository });
    }
}
exports.ClassServiceFactory = ClassServiceFactory;
