"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container = void 0;
const class_repository_1 = require("../../infrastructure/repository/class.repository");
const student_repository_1 = require("../../infrastructure/repository/student.repository");
const teacher_repository_1 = require("../../infrastructure/repository/teacher.repository");
const class_service_factory_1 = require("./class/class.service.factory");
const teacher_service_factory_1 = require("./teacher/teacher.service.factory");
const student_service_factory_1 = require("./student/student.service.factory");
const topic_service_factory_1 = require("./topic/topic.service.factory");
const teacher_controller_factory_1 = require("./teacher/teacher.controller.factory");
const class_controller_factory_1 = require("./class/class.controller.factory");
const student_controller_factory_1 = require("./student/student.controller.factory");
const teacher_router_factory_1 = require("./teacher/teacher.router.factory");
const student_router_factory_1 = require("./student/student.router.factory");
const class_router_factory_1 = require("./class/class.router.factory");
const topic_repository_1 = require("../../infrastructure/repository/topic.repository");
const user_repository_1 = require("../../infrastructure/repository/user.repository");
const roles_repository_1 = require("../../infrastructure/repository/roles.repository");
const category_repository_1 = require("../../infrastructure/repository/category.repository");
const discipline_repository_1 = require("../../infrastructure/repository/discipline.repository");
const user_service_factory_1 = require("./user/user.service.factory");
const roles_service_factory_1 = require("./roles/roles.service.factory");
const category_service_factory_1 = require("./category/category.service.factory");
const discipline_service_factory_1 = require("./discipline/discipline.service.factory");
const user_auth_service_factory_1 = require("./user/auth/user.auth.service.factory");
const student_auth_service_factory_1 = require("./student/auth/student.auth.service.factory");
const teacher_auth_service_factory_1 = require("./teacher/auth/teacher.auth.service.factory");
const user_auth_middleware_factory_1 = require("./user/auth/user.auth.middleware.factory");
const user_auth_controller_factory_1 = require("./user/auth/user.auth.controller.factory");
const user_auth_router_factory_1 = require("./user/auth/user.auth.router.factory");
const user_controller_factory_1 = require("./user/user.controller.factory");
const user_router_factory_1 = require("./user/user.router.factory");
const roles_controller_factory_1 = require("./roles/roles.controller.factory");
const category_controller_factory_1 = require("./category/category.controller.factory");
const discipline_controller_factory_1 = require("./discipline/discipline.controller.factory");
const topic_controller_factory_1 = require("./topic/topic.controller.factory");
const roles_router_factory_1 = require("./roles/roles.router.factory");
const category_router_factory_1 = require("./category/category.router.factory");
const discipline_router_factory_1 = require("./discipline/discipline.router.factory");
const topic_router_factory_1 = require("./topic/topic.router.factory");
const permissions_middleware_factory_1 = require("./roles/permissions.middleware.factory");
const student_auth_controller_factory_1 = require("./student/auth/student.auth.controller.factory");
const teacher_auth_controller_factory_1 = require("./teacher/auth/teacher.auth.controller.factory");
const student_auth_router_factory_1 = require("./student/auth/student.auth.router.factory");
const teacher_auth_router_factory_1 = require("./teacher/auth/teacher.auth.router.factory");
const teacher_auth_middleware_factory_1 = require("./teacher/auth/teacher.auth.middleware.factory");
const student_auth_middleware_factory_1 = require("./student/auth/student.auth.middleware.factory");
/**
 * Instantiates the modules correctly
 * @returns Array of Routers
 */
class Container {
    static inicialize() {
        /**
         * Instantiates the repositories
         */
        const userRepo = new user_repository_1.UserRepository();
        const rolesRepo = new roles_repository_1.RolesRepository();
        const categoryRepo = new category_repository_1.CategoryRepository();
        const disciplineRepo = new discipline_repository_1.DisciplineRepository();
        const topicRepo = new topic_repository_1.TopicRepository();
        const teacherRepo = new teacher_repository_1.TeacherRepository();
        const studentRepo = new student_repository_1.StudentRepository();
        const classRepo = new class_repository_1.ClassRepository();
        /*
         * Instantiates the services
         */
        const userAuthService = user_auth_service_factory_1.UserAuthServiceFactory.create(userRepo);
        const userService = user_service_factory_1.UserServiceFactory.create(userRepo);
        const rolesService = roles_service_factory_1.RolesServiceFactory.create(rolesRepo);
        const categoryService = category_service_factory_1.CategoryServiceFactory.create(categoryRepo);
        const disciplineService = discipline_service_factory_1.DisciplineServiceFactory.create(disciplineRepo);
        const topicService = topic_service_factory_1.TopicServiceFactory.create(topicRepo);
        const studentService = student_service_factory_1.StudentServiceFactory.create(studentRepo);
        const studentAuthService = student_auth_service_factory_1.StudentAuthServiceFactory.create(studentRepo);
        const teacherService = teacher_service_factory_1.TeacherServiceFactory.create(teacherRepo);
        const teacherAuthService = teacher_auth_service_factory_1.TeacherAuthServiceFactory.create(teacherRepo);
        const classService = class_service_factory_1.ClassServiceFactory.create(classRepo);
        /**
         * Injecting the dependences
         */
        // User
        userService.listRolesDep = rolesService.listRoles;
        userService.createStudentDep = studentService.createStudent;
        userService.getStudentByIdDep = studentService.getStudentById;
        userService.listStudentsDep = studentService.listStudents;
        userService.updateStudentDep = studentService.updateStudent;
        userService.deleteStudentDep = studentService.deleteStudent;
        userService.createTeacherDep = teacherService.createTeacher;
        userService.getTeachersDep = teacherService.getTeacherById;
        userService.listTeachersDep = teacherService.listTeacher;
        userService.updateTeacherDep = teacherService.updateTeacherById;
        userService.deleteTeacherDep = teacherService.deleteTeacherById;
        // Discipline
        disciplineService.getCategoryById = categoryService.getCategoryById;
        // Topic
        topicService.getDisciplineById = disciplineService.getDisciplineById;
        // Teacher
        teacherService.listClassesDep = classService.listClasses;
        teacherService.getClassByIdDep = classService.getClassById;
        teacherService.updateClassByIdDep = classService.updateClassById;
        teacherService.listTopicsDep = topicService.listTopics;
        // Student
        studentService.listTeachersDep = teacherService.findTeacherForStudent;
        studentService.createClassDep = classService.createClass;
        studentService.getClassByIdDep = classService.getClassById;
        studentService.listClassesDep = classService.listClasses;
        studentService.updateClassDep = classService.updateClassById;
        // Class
        classService.listStudents = studentService.listStudents;
        classService.getStudentById = studentService.getStudentById;
        classService.getTeacherById = teacherService.getTeacherById;
        classService.getTopicById = topicService.getTopicById;
        /**
         * Inicialize the middlewares
         */
        const userAuthMiddleware = user_auth_middleware_factory_1.UserAuthMiddlewareFactory.create(userAuthService);
        const teacherAuthMiddleware = teacher_auth_middleware_factory_1.TeacherAuthMiddlewareFactory.create(teacherAuthService);
        const studentAuthMiddleware = student_auth_middleware_factory_1.StudentAuthMiddlewareFactory.create(studentAuthService);
        const permissionsMiddleware = permissions_middleware_factory_1.PermissionsMiddlewareFactory.create(rolesService);
        /**
         * Instantiates the controllers
         */
        const userAuthController = user_auth_controller_factory_1.UserAuthControllerFactory.create(userAuthService);
        const userController = user_controller_factory_1.UserControllerFactory.create(userService);
        const rolesController = roles_controller_factory_1.RolesControllerFactory.create(rolesService);
        const categoryController = category_controller_factory_1.CategoryControllerFactory.create(categoryService);
        const disciplineController = discipline_controller_factory_1.DisciplineControllerFactory.create(disciplineService);
        const topicController = topic_controller_factory_1.TopicControllerFactory.create(topicService);
        const studentAuthController = student_auth_controller_factory_1.StudentAuthControllerFactory.create(studentAuthService);
        const studentController = student_controller_factory_1.StudentControllerFactory.create(studentService);
        const teacherAuthController = teacher_auth_controller_factory_1.TeacherAuthControllerFactory.create(teacherAuthService);
        const teacherController = teacher_controller_factory_1.TeacherControllerFactory.create(teacherService);
        const classController = class_controller_factory_1.ClassControllerFactory.create(classService);
        /**
         * Instantiates the routers injecting the correct dependencies
        **/
        /**
         * Authentication routes for each entity type
         */
        const userAuthRouter = user_auth_router_factory_1.UserAuthRouterFactory.create(userAuthController, userAuthMiddleware);
        const studentAuthRouter = student_auth_router_factory_1.StudentAuthRouterFactory.create(studentAuthController, studentAuthMiddleware);
        const teacherAuthRouter = teacher_auth_router_factory_1.TeacherAuthRouterFactory.create(teacherAuthController, teacherAuthMiddleware);
        /**
         * CRUD functions for Roles
         * Only authenticated users have access
         */
        const rolesRouter = roles_router_factory_1.RolesRouterFactory.create(rolesController, userAuthMiddleware, permissionsMiddleware);
        /**
         * CRUD functions for Categories
         */
        const categoryRouter = category_router_factory_1.CategoryRouterFactory.create(categoryController, userAuthMiddleware, permissionsMiddleware);
        /**
         * CRUD functions for Disciplines
         */
        const disciplineRouter = discipline_router_factory_1.DisciplineRouterFactory.create(disciplineController, userAuthMiddleware, permissionsMiddleware);
        /**
         * CRUD functions for Topics
         */
        const topicRouter = topic_router_factory_1.TopicRouterFactory.create(topicController, userAuthMiddleware, permissionsMiddleware);
        /**
         * CRUD functions for Classes
         */
        const classRouter = class_router_factory_1.ClassRouterFactory.create(classController);
        /**
         * CRUD functions for Users admin
         */
        const userRouter = user_router_factory_1.UserRouterFactory.create(userController, userAuthRouter, classRouter, userAuthMiddleware, permissionsMiddleware);
        /**
         * CRUD functions for Students
         */
        const studentRouter = student_router_factory_1.StudentRouterFactory.create(studentController, studentAuthRouter, studentAuthMiddleware);
        /**
         * CRUD functions for Teachers
         */
        const teacherRouter = teacher_router_factory_1.TeacherRouterFactory.create(teacherController, teacherAuthRouter, teacherAuthMiddleware);
        /**
         * Export all routers
         */
        return [
            userRouter,
            rolesRouter,
            categoryRouter,
            disciplineRouter,
            topicRouter,
            studentRouter,
            teacherRouter,
        ];
    }
}
exports.Container = Container;
