"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineControllerFactory = void 0;
const discipline_controller_1 = require("../../../modules/Discipline/discipline.controller");
const discipline_schema_1 = require("../../schemas/discipline.schema");
/**
 * Factory class to create DisciplineController instances.
 */
class DisciplineControllerFactory {
    /**
     * Create and return a new DisciplineController instance
     * @returns DisciplineController instance
     */
    static create(service) {
        return new discipline_controller_1.DisciplineController(service, discipline_schema_1.disciplineSchemas);
    }
}
exports.DisciplineControllerFactory = DisciplineControllerFactory;
