"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineRouterFactory = void 0;
const discipline_router_1 = require("../../routes/discipline.router");
/**
 * Factory class to create DisciplineRouter instances.
 */
class DisciplineRouterFactory {
    /**
     * Create and return a new DisciplineRouter instance
     * @returns DisciplineRouter instance
     */
    static create(controller, authMiddleware, permissionsMiddleware) {
        return new discipline_router_1.DisciplineRouter(controller, authMiddleware, permissionsMiddleware);
    }
}
exports.DisciplineRouterFactory = DisciplineRouterFactory;
