"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineServiceFactory = void 0;
const discipline_service_1 = require("../../../modules/Discipline/discipline.service");
/**
 * Factory class to create DisciplineService instances.
 */
class DisciplineServiceFactory {
    /**
     * Create and return a new DisciplineService instance
     * @returns DisciplineService instance
     */
    static create(repository) {
        return new discipline_service_1.DisciplineService({ repository });
    }
}
exports.DisciplineServiceFactory = DisciplineServiceFactory;
