"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsMiddlewareFactory = void 0;
const permissions_middleware_1 = require("../../../shared/middlewares/permissions.middleware");
/**
 * Factory class to create PermissionMiddleware instances.
 */
class PermissionsMiddlewareFactory {
    /**
     * Create and return a new PermissionMiddleware instance
     * @returns PermissionMiddleware instance
     */
    static create(roleService) {
        return (0, permissions_middleware_1.CreatePermissionsMiddleware)(roleService);
    }
}
exports.PermissionsMiddlewareFactory = PermissionsMiddlewareFactory;
