"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesControllerFactory = void 0;
const roles_controller_1 = require("../../../modules/Roles/roles.controller");
const roles_schema_1 = require("../../schemas/roles.schema");
/**
 * Factory class to create RoleController instances.
 */
class RolesControllerFactory {
    /**
     * Create and return a new RoleController instance
     * @returns RoleController instance
     */
    static create(service) {
        return new roles_controller_1.RoleController(service, roles_schema_1.roleSchemas);
    }
}
exports.RolesControllerFactory = RolesControllerFactory;
