"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesRouterFactory = void 0;
const roles_router_1 = require("../../routes/roles.router");
/**
 * Factory class to create RolesRouter instances.
 */
class RolesRouterFactory {
    /**
     * Create and return a new RolesRouter instance
     * @returns RolesRouter instance
     */
    static create(controller, authMiddleware, permissionsMiddleware) {
        return new roles_router_1.RolesRouter(controller, authMiddleware, permissionsMiddleware);
    }
}
exports.RolesRouterFactory = RolesRouterFactory;
