"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesServiceFactory = void 0;
const roles_service_1 = require("../../../modules/Roles/roles.service");
/**
 * Factory class to create RoleService instances.
 */
class RolesServiceFactory {
    /**
     * Create and return a new RoleService instance
     * @returns RoleService instance
     */
    static create(repository) {
        return new roles_service_1.RoleService({ RoleRepository: repository });
    }
}
exports.RolesServiceFactory = RolesServiceFactory;
