"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentAuthMiddlewareFactory = void 0;
const auth_middleware_factory_1 = require("../../auth/auth.middleware.factory");
/**
 * Specific factory for creating Student authentication middleware
 */
class StudentAuthMiddlewareFactory {
    /**
     * Creates an authentication middleware for Student
     * @param studentRepository - Student repository
     * @returns Student authentication middleware
     */
    static create(authService) {
        return auth_middleware_factory_1.AuthMiddlewareFactory.create(authService);
    }
}
exports.StudentAuthMiddlewareFactory = StudentAuthMiddlewareFactory;
