"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentAuthRouterFactory = void 0;
const auth_router_1 = require("../../../routes/auth.router");
/**
 * Specific factory for creating AuthRouter for Student
 */
class StudentAuthRouterFactory {
    /**
     * Creates an AuthRouter configured for Student
     * @param studentRepository - Student repository
     * @returns AuthRouter for Student
     */
    static create(authController, authMiddleware) {
        return new auth_router_1.AuthRouter(authController, authMiddleware);
    }
}
exports.StudentAuthRouterFactory = StudentAuthRouterFactory;
