"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentAuthServiceFactory = void 0;
const auth_service_1 = require("../../../../modules/auth/auth.service");
const student_auth_adaptor_interface_1 = require("../../../../modules/Student/interfaces/student.auth.adaptor.interface");
const student_entity_1 = require("../../../../modules/Student/student.entity");
/**
 * Specific factory for creating AuthService for Student
 */
class StudentAuthServiceFactory {
    /**
     * Creates an instance of AuthService configured for Student
     * @param studentRepository - Student repository
     * @returns AuthService instance for Student
     */
    static create(studentRepository) {
        // Adapts the Student repository to work with IStudentAuthAdapter
        const repository = {
            findById: (id) => __awaiter(this, void 0, void 0, function* () {
                const student = yield studentRepository.getStudentById(id);
                return student ? (0, student_auth_adaptor_interface_1.adaptStudentForAuth)(student) : null;
            }),
            findByEmail: (email) => __awaiter(this, void 0, void 0, function* () {
                const student = yield studentRepository.getStudentByEmail(email);
                return student ? (0, student_auth_adaptor_interface_1.adaptStudentForAuth)(student) : null;
            }),
            create: (params) => __awaiter(this, void 0, void 0, function* () {
                const student = yield studentRepository.createStudent(params);
                return (0, student_auth_adaptor_interface_1.adaptStudentForAuth)(student);
            }),
            update: (id, params) => __awaiter(this, void 0, void 0, function* () {
                const student = yield studentRepository.updateStudent(id, params);
                return student ? (0, student_auth_adaptor_interface_1.adaptStudentForAuth)(student) : null;
            })
        };
        /**
         * Constructor for new student instance
         * @param params - Required data for student registration
         * @returns Student instance
         */
        const entity = (params) => {
            const data = {
                full_name: params.full_name,
                email: params.email,
                password: params.password,
                birth_date: params.birth_date,
                cpf: params.cpf,
                telephone: params.telephone,
                academic: params.academic,
                class_preferences: params.class_preferences,
                guardian: params.guardian,
                ranking: params.ranking,
                total_classes: params.total_classes,
            };
            const validatedUser = new student_entity_1.Student(data);
            return (0, student_auth_adaptor_interface_1.adaptStudentForAuth)(validatedUser.getData());
        };
        return new auth_service_1.AuthService({
            repository,
            entity
        });
    }
}
exports.StudentAuthServiceFactory = StudentAuthServiceFactory;
