"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentControllerFactory = void 0;
const student_controller_1 = require("../../../modules/Student/student.controller");
const student_schema_1 = require("../../schemas/student.schema");
/**
 * Factory class to create StudentController instances.
 */
class StudentControllerFactory {
    /**
     * Create and return a new StudentController instance
     * @returns StudentController instance
     */
    static create(service) {
        return new student_controller_1.StudentController(service, student_schema_1.studentSchemas);
    }
}
exports.StudentControllerFactory = StudentControllerFactory;
