"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentServiceFactory = void 0;
const student_service_1 = require("../../../modules/Student/student.service");
/**
 * Factory class to create StudentService instances.
 */
class StudentServiceFactory {
    /**
     * Create and return a new StudentService instance
     * @returns StudentService instance
     */
    static create(repository) {
        return new student_service_1.StudentService({ repository });
    }
}
exports.StudentServiceFactory = StudentServiceFactory;
