"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherAuthMiddlewareFactory = void 0;
const auth_middleware_factory_1 = require("../../auth/auth.middleware.factory");
/**
 * Factory específica para criar middleware de autenticação para Teacher
 */
class TeacherAuthMiddlewareFactory {
    /**
     * Cria um middleware de autenticação para Teacher
     * @param teacherRepository - Repositório de professores
     * @returns Middleware de autenticação para Teacher
     */
    static create(authService) {
        return auth_middleware_factory_1.AuthMiddlewareFactory.create(authService);
    }
}
exports.TeacherAuthMiddlewareFactory = TeacherAuthMiddlewareFactory;
