"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherAuthRouterFactory = void 0;
const auth_router_1 = require("../../../routes/auth.router");
/**
 * Factory específica para criar AuthRouter para Teacher
 */
class TeacherAuthRouterFactory {
    /**
     * Cria um AuthRouter configurado para Teacher
     * @param teacherRepository - Repositório de professores
     * @returns AuthRouter para Teacher
     */
    static create(authController, authMiddleware) {
        return new auth_router_1.AuthRouter(authController, authMiddleware);
    }
}
exports.TeacherAuthRouterFactory = TeacherAuthRouterFactory;
