"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherAuthServiceFactory = void 0;
const auth_service_1 = require("../../../../modules/auth/auth.service");
const teacher_auth_adaptor_interface_1 = require("../../../../modules/Teacher/interfaces/teacher.auth.adaptor.interface");
const teacher_entity_1 = require("../../../../modules/Teacher/teacher.entity");
/**
 * Factory específica para criar AuthService para Teacher
 */
class TeacherAuthServiceFactory {
    /**
     * Cria uma instância do AuthService configurada para Teacher
     * @param teacherRepository - Repositório de professores
     * @returns Instância do AuthService para Teacher
     */
    static create(teacherRepository) {
        // Adapta o repositório de Teacher para trabalhar com ITeacherAuthAdapter
        const repository = {
            findById: (id) => __awaiter(this, void 0, void 0, function* () {
                const teacher = yield teacherRepository.getTeacherById(id);
                return teacher ? (0, teacher_auth_adaptor_interface_1.adaptTeacherForAuth)(teacher) : null;
            }),
            findByEmail: (email) => __awaiter(this, void 0, void 0, function* () {
                const teacher = yield teacherRepository.getTeacherByEmail(email);
                return teacher ? (0, teacher_auth_adaptor_interface_1.adaptTeacherForAuth)(teacher) : null;
            }),
            create: (params) => __awaiter(this, void 0, void 0, function* () {
                const teacher = yield teacherRepository.createTeacher(params);
                return (0, teacher_auth_adaptor_interface_1.adaptTeacherForAuth)(teacher);
            }),
            update: (id, params) => __awaiter(this, void 0, void 0, function* () {
                const teacher = yield teacherRepository.updateTeacherById(id, params);
                return teacher ? (0, teacher_auth_adaptor_interface_1.adaptTeacherForAuth)(teacher) : null;
            })
        };
        /**
         * Constructor for new teacher instance
         * @param params - Required data for teacher registration
         * @returns Teacher instance
         */
        const entity = (params) => {
            const data = {
                full_name: params.full_name,
                email: params.email,
                password: params.password,
                birth_date: params.birth_date,
                cpfCnpj: params.cpfCnpj,
                rg: params.rg,
                telephone: params.telephone,
                address: params.address,
                education: params.education,
                availability: params.availability,
                preferences: params.preferences,
            };
            const validatedUser = new teacher_entity_1.Teacher(data);
            return (0, teacher_auth_adaptor_interface_1.adaptTeacherForAuth)(validatedUser.getData());
        };
        return new auth_service_1.AuthService({ repository, entity });
    }
}
exports.TeacherAuthServiceFactory = TeacherAuthServiceFactory;
