"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherControllerFactory = void 0;
const teacher_controller_1 = require("../../../modules/Teacher/teacher.controller");
const teacher_schema_1 = require("../../schemas/teacher.schema");
/**
 * Factory class to create TeacherController instances.
 */
class TeacherControllerFactory {
    /**
     * Create and return a new TeacherController instance
     * @returns TeacherController instance
     */
    static create(service) {
        return new teacher_controller_1.TeacherController(service, teacher_schema_1.teacherSchemas);
    }
}
exports.TeacherControllerFactory = TeacherControllerFactory;
