"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherRouterFactory = void 0;
const teacher_router_1 = require("../../routes/teacher.router");
/**
 * Factory class to create TeacherRouter instances.
 */
class TeacherRouterFactory {
    /**
     * Create and return a new TeacherRouter instance
     * @returns TeacherRouter instance
     */
    static create(controller, authRouter, authMiddleware) {
        return new teacher_router_1.TeacherRouter(controller, authRouter, authMiddleware);
    }
}
exports.TeacherRouterFactory = TeacherRouterFactory;
