"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherServiceFactory = void 0;
const teacher_service_1 = require("../../../modules/Teacher/teacher.service");
/**
 * Factory class to create TeacherService instances.
 */
class TeacherServiceFactory {
    /**
     * Create and return a new TeacherService instance
     * @returns TeacherService instance
     */
    static create(repository) {
        return new teacher_service_1.TeacherService({ repository });
    }
}
exports.TeacherServiceFactory = TeacherServiceFactory;
