"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicControllerFactory = void 0;
const topic_controller_1 = require("../../../modules/Topic/topic.controller");
const topic_schema_1 = require("../../schemas/topic.schema");
/**
 * Factory class to create TopicController instances.
 */
class TopicControllerFactory {
    /**
     * Create and return a new TopicController instance
     * @returns TopicController instance
     */
    static create(service) {
        return new topic_controller_1.TopicController(service, topic_schema_1.topicSchemas);
    }
}
exports.TopicControllerFactory = TopicControllerFactory;
