"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRouterFactory = void 0;
const topic_router_1 = require("../../routes/topic.router");
/**
 * Factory class to create TopicRouter instances.
 */
class TopicRouterFactory {
    /**
     * Create and return a new TopicRouter instance
     * @returns TopicRouter instance
     */
    static create(controller, authMiddleware, permissionsMiddleware) {
        return new topic_router_1.TopicRouter(controller, authMiddleware, permissionsMiddleware);
    }
}
exports.TopicRouterFactory = TopicRouterFactory;
