"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicServiceFactory = void 0;
const topic_service_1 = require("../../../modules/Topic/topic.service");
/**
 * Factory class to create TopicService instances.
 */
class TopicServiceFactory {
    /**
     * Create and return a new TopicService instance
     * @returns TopicService instance
     */
    static create(repository) {
        return new topic_service_1.TopicService({ repository });
    }
}
exports.TopicServiceFactory = TopicServiceFactory;
