"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAuthMiddlewareFactory = void 0;
const auth_middleware_factory_1 = require("../../auth/auth.middleware.factory");
/**
 * Specific factory for creating User authentication middleware
 */
class UserAuthMiddlewareFactory {
    /**
     * Creates an authentication middleware for User
     * @param userRepository - User repository
     * @returns User authentication middleware
     */
    static create(authService) {
        return auth_middleware_factory_1.AuthMiddlewareFactory.create(authService);
    }
}
exports.UserAuthMiddlewareFactory = UserAuthMiddlewareFactory;
