"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAuthRouterFactory = void 0;
const auth_router_1 = require("../../../routes/auth.router");
/**
 * Specific factory for creating AuthRouter for User
 */
class UserAuthRouterFactory {
    /**
     * Creates an AuthRouter configured for User
     * @param userRepository - User repository
     * @returns AuthRouter for User
     */
    static create(authController, authMiddleware) {
        return new auth_router_1.AuthRouter(authController, authMiddleware);
    }
}
exports.UserAuthRouterFactory = UserAuthRouterFactory;
